<?php
/*************************************************************
 *
 * Copyright (c) 2022 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2022 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	: 2022.09.07
 *
 *************************************************************/
if(defined('INCLUDED_CONFIG')) return;
define('INCLUDED_CONFIG', 1);

// フォーム再送信の確認対策
header('Expires:-1');
header('Cache-Control:');
header('Pragma:');

// 全ての PHP エラーを表示する
error_reporting(E_ALL);
// エラーを出力する
ini_set('display_errors', 1);

// 言語設定
mb_language('ja');
// 内部文字エンコーディングをUTF-8に設定
mb_internal_encoding("UTF-8");



/************************************************************
 *
 * サイト情報
 *
 ************************************************************/
// サイト名
define('NAME', 'マイライブラリ集');
// 送信専用メールアドレス
define('MAIL_NOREPLY', 'noreply@'.$_SERVER['HTTP_HOST']);
// テーマ
define('THEME', 'ios_220907');



/************************************************************
 *
 * データベース
 *
 ************************************************************/
// ホスト名 or IPアドレス
# define('DB_HOST', 'localhost');
// データベース名
# define('DB_NAME', 'name');
// ユーザ名
# define('DB_USER', 'user');
// パスワード
# define('DB_PASS', 'password');
// テーブル接頭辞
# define('DB_PREFIX', 'orig_');



/************************************************************
 *
 * 認証
 *
 ************************************************************/
// ログインページ
define('LOGIN_HTML', "{$_SERVER['DOCUMENT_ROOT']}/login/index.html");
// アカウントのname値
define('LOGIN_ACCOUNT', 'account');
// パスワードのname値
define('LOGIN_PASSWORD', 'password');
// ログインに失敗時の文言
define('LOG_IN_FAILED', 'ログインに失敗しました');
// ログアウト時の文言
define('LOG_OUT_MSG', 'ログアウトしました');
// セッション：保存ディレクトリ
define('SESSION_DIR', $_SERVER['DOCUMENT_ROOT']."/commons/session");
// セッション：有効期限
define('SESSION_TIME', 86400);
// 認証クラス
if(is_file("{$_SERVER['DOCUMENT_ROOT']}/login/auth.php")) require_once "{$_SERVER['DOCUMENT_ROOT']}/login/auth.php";



/************************************************************
 *
 * インクルード
 *
 ************************************************************/
$inc_dir = $_SERVER['DOCUMENT_ROOT'].'/commons/includes';
$inc = scandir($inc_dir);
foreach($inc as $f){
  if(!is_file("{$inc_dir}/{$f}")) continue;
  require_once "{$inc_dir}/{$f}";
};// END foreach
?>