;
/*************************************************************
 *
 * Copyright (c) 2022 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2022 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	: 2022.09.14
 *
 ************************************************************/
'use strict';
(function($){

  $(document).ready(function(){
    // 代理ログインの場合、簡易ログインを表示
    if(location.search.match(/type=proxy/)) simpleForm.proxyLogin();
    // ログイン履歴がある場合、簡易ログインを表示
    else if(simpleForm.hasHistory()) simpleForm.changeForm( JSON.parse(localStorage.getItem(localStorage.getItem('last_account'))) );

    // 通常ログイン：送信時
    $('#login').submit( normalForm.submit() );
  });



  /**********************************************************************
   *
   *　通常ログイン
   *
   **********************************************************************/
  let normalForm = (function(){
    return{
      /************************************************************
       *
       * 送信時
       *
       ************************************************************/
      'submit' : function(){
        return(function(e){
          // デフォルトをキャンセル
          e.preventDefault();
          // 再送信防止
          $('#login button[type=submit]').prop('disabled', true);
          // UUIDを生成しフォームに追加する
          normalForm.appendUuid( $.fn.ysMkUUID() );
          // 既存のフォームからAjaxのオブジェクトを作成する
          let obj = $('#login').ysAjax();
          // 非同期処理
          $.ajax(obj.settings).fail(obj['fail'](obj)).done(function(data, textStatus, jqXHR){
            // 送信ボタン活性化
            $('#login button[type=submit]').prop('disabled', false);
            // 成功以外は処理しない
            if(textStatus != 'success') return;
            // 戻り値をJSONに変換
            let result = $.fn.ysToJSON(data);
            // ログインに失敗
            if(normalForm.failed(result)) return;

            // ログイン情報を端末に保存する
            if($('#save').prop('checked')){
              // 最終ログインとして保存
              localStorage.setItem('last_account', $('#account').val());
              // 保存するアカウント情報
              let data = JSON.stringify({
                           'account' : $('#account').val()
                          ,'password' : $('#password').val()
                          ,'name' : result['account']['name']
                          ,'time' : (new Date()).getTime()
                         });
              // アカウント情報を保存
              localStorage.setItem($('#account').val(), data);
            };// END if ログイン情報を端末に保存する
            // ジャンプ
            $('#jump').append('<input type="hidden" name="uuid" value="' + result['account']['uuid'] + '">').submit();
          });// END 非同期処理

        });
      },

      /*
       * UUIDを生成しフォームに追加する
       */
      'appendUuid' : function(uuid){
        // 既にUUIDが存在している場合は処理しない
        if( $('#login input[name=uuid]')[0] ) return;
        // 追加する
        $('#login').append('<input type="hidden" name="uuid" value="' + uuid + '">');
      },

      /*
       * ログインに失敗
       */
      'failed' : function( result ){
        // 戻り値が不正
        if(result === false) result = {};
        // ステータスが不正
        if('status' in result === false) result['status'] = "false";

        // ログインに成功
        if(result['status'] == "true") return false;
        // ログインに失敗
        if('msg' in result) $.fn.ysAlert(result['msg'], { 'body' : 'アカウントまたはパスワードが正しくありません。' });
        // 戻り値が不正
        else $.fn.ysAlert('処理が中断しました', { 'body' : 'しばらくたってから再度ログインしてください。' });
        // 真を返す
        return true;
      },
      /********** END 送信時 ********************/



      /************************************************************
       *
       * 通常ログインを表示
       *
       ************************************************************/
      'changeForm' : function(){
        $('#login').removeClass('simple');
        $('#account').attr('type', 'text');
        $('#password').attr('type', 'password');
        $('#login button[type=submit]').text('ログイン');
      },
      /********** END 通常ログインを表示 ********************/

    }
  })();
  /********** END 通常ログイン ********************/



  /**********************************************************************
   *
   *　簡易ログイン
   *
   **********************************************************************/
  let simpleForm = (function(){
    return{
      /************************************************************
       *
       * 代理ログインの場合
       *
       ************************************************************/
      'proxyLogin' : function(){
        if(location.search.match(/type=proxy&account=([^\x26]+)\x26password=([^\x26]+)\x26name=(.+)$/)){
          // 簡易ログインフォームに変更する
          simpleForm.changeForm({'account':RegExp.$1
                                ,'password':RegExp.$2
                                ,'name':decodeURIComponent(RegExp.$3)
                                });
        };// END if
      },
      /********** END 代理ログインの場合 ********************/



      /************************************************************
       *
       * ログイン履歴がある場合
       *
       ************************************************************/
      'hasHistory' : function(){
        // 最終ログインがない場合は処理しない
        if(!localStorage.hasOwnProperty('last_account')) return;
        // 最終ログインアカウントを取得
        let mail = localStorage.getItem('last_account');
        // ログイン履歴の中に存在しない場合は処理しない
        if(!localStorage.hasOwnProperty(mail)) return;
        // 真を返す
        return true;
      },
      /********** END ログイン履歴がある場合 ********************/



      /************************************************************
       *
       * 簡易ログインを表示
       *
       ************************************************************/
      'changeForm' : function( JSON ){
        // 情報不足の時は通常フォームに戻す
        if('account' in JSON === false || 'password' in JSON === false || 'name' in JSON === false) return normalForm.changeForm();
        // 既に簡易ログインフォームの場合は処理しない
        if($('#login').hasClass('simple')) return;
        // アカウント
        $('#account').attr('type', 'hidden').val( JSON['account'] );
        // パスワード
        $('#password').attr('type', 'hidden').val( JSON['password'] );
        // ボタンの文言を変更
        $('#login button[type=submit]').text(JSON['name'] + ' 様としてログイン');
        // クラスの適用
        $('#login').addClass('simple');
        // 別のアカウントでログインする
        $('#login').append($('<div>')
          .addClass('other')
          .html('別のアカウントでログインする')
          .click(function(){
             // 通常フォームに戻す
             normalForm.changeForm();
             // 自身の削除
             $(this).remove();
           })
        );
      },
      /********** END 簡易ログインを表示 ********************/

    }
  })();
  /********** END 簡易ログイン ********************/



//  /**********************************************************************
//   *
//   *　即時関数
//   *
//   **********************************************************************/
//  let capsule = (function(){
//    return{
//      /************************************************************
//       *
//       * メソッド
//       *
//       ************************************************************/
//      'method' : function(){
//      },
//      /********** END メソッド ********************/
//
//    }
//  })();
//  /********** END 即時関数 ********************/


})(jQuery);