<?php
/*************************************************************
 *
 * Copyright (c) 2022 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2022 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	: 2022.09.13
 *
 *************************************************************/
class Auth{
  // UUID
  public $uuid;
  // ログインに関するメッセージ
  public $msg;

  /**************************************************
   *
   * 初期設定
   *
   **************************************************/
  public function __construct(){
    // データベース情報が未設定
    if(!defined('DB_HOST')) $this->die_msg('DB_HOST is not defined');
    if(!defined('DB_NAME')) $this->die_msg('DB_NAME is not defined');
    if(!defined('DB_USER')) $this->die_msg('DB_USER is not defined');
    if(!defined('DB_PASS')) $this->die_msg('DB_PASS is not defined');
    if(!defined('DB_PREFIX')) $this->die_msg('DB_PREFIX is not defined');
    // ログインページ
    if(!defined('LOGIN_HTML')) $this->die_msg('LOGIN_HTML is not defined');
    if(!is_file(LOGIN_HTML)) $this->die_msg('LOGIN_HTML is not exists');


    // 定数の未設定：セッションを保存するディレクトリ
    if(!defined('SESSION_DIR')) define('SESSION_DIR', __DIR__."/session");
    // 定数の未設定：セッションの有効期限
    if(!defined('SESSION_TIME')) define('SESSION_TIME', 86400);

    // 定数の未設定：ログインアカウントのname値
    if(!defined('LOGIN_ACCOUNT')) define('LOGIN_ACCOUNT', 'account');
    // 定数の未設定：ログインパスワードのname値
    if(!defined('LOGIN_PASSWORD')) define('LOGIN_PASSWORD', 'password');

    // 定数の未設定：ログインに失敗
    if(!defined('LOG_IN_FAILED')) define('LOG_IN_FAILED', 'ログインに失敗しました');
    // 定数の未設定：ログアウト時の文言
    if(!defined('LOG_OUT_MSG')) define('LOG_OUT_MSG', 'ログアウトしました');


    // UUIDを変数に代入
    $this->uuid = isset($_REQUEST['uuid']) ? $_REQUEST['uuid'] : $GLOBALS['class']['ys_commons']->getUuidV4();

    // セッションディレクトリが存在しない
    if(!is_dir(SESSION_DIR)){
      // ディレクトリを作成
      if(@mkdir(SESSION_DIR, 0666) === false) $this->die_msg("セッションディレクトリの作成に失敗しました。[ ".SESSION_DIR.' ]');
      // パーミッションを変更
      chmod(SESSION_DIR, 0775);
    };// END if セッションディレクトリが存在しない


    // セッションの保存ディレクトリ
    ini_set('session.save_path', SESSION_DIR);
    // セッションを開始
    session_start();
    // セッションファイル
    $sess = ini_get('session.save_path').'/sess_'.session_id();
    // セッションIDを更新
    if(is_file($sess) && (filemtime($sess)+SESSION_TIME)<time()) session_regenerate_id(true);
  }
  /********** END 初期設定 ********************/



  /**************************************************
   *
   * 全てのセッションで呼び出される関数
   *
   **************************************************/
  public function session(){
    // ログイン済みは処理しない
    if( $this->is_login() ) return true;
    // セッションをクリアする
    $this->session_clear();
    // Ajaxの時はエラーを返す
    if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'){
      header("Content-Type: application/json; charset=utf-8");
      echo json_encode(['status'=>'false', 'location'=>str_replace($_SERVER['DOCUMENT_ROOT'], "", LOGIN_HTML) ]);
      exit;
    };// END if
    // ログインページを開く
    require_once LOGIN_HTML;
    // これ以上処理しない
    exit;
  }
  /********** END 全てのセッションで呼び出される関数 ********************/



  /**************************************************
   *
   * 既にログイン中は真を返す
   *
   **************************************************/
  public function is_login(){
    // ログアウト処理では処理しない
    if(isset($_REQUEST['logout'])) return $this->exec_logout();
// ログイン処理は現時点ではAjaxでしている為
//    // ログインしようとしている時は処理しない
//    if(isset($_REQUEST[LOGIN_ACCOUNT]) || isset($_REQUEST[LOGIN_PASSWORD])) return;
    // セッションが存在しなかった場合は処理しない
    if(!isset($_SESSION[ $this->uuid ])) return;
    // セッションの有効期限切れ
    if(!isset($_SESSION[ $this->uuid ]['expiration']) || $_SESSION[ $this->uuid ]['expiration'] < (time() - SESSION_TIME)) return;
    // セッションの更新
    $_SESSION[ $this->uuid ]['expiration'] = time();
    // 真を返す
    return true;
  }
  /********** END 既にログイン中はtrueを返す ********************/



  /**************************************************
   *
   * ログアウト処理
   *
   **************************************************/
  public function exec_logout(){
    // セッション情報をクリアする
    $this->session_clear();
    // 文言を変数に代入
    $GLOBALS['message'] = LOG_OUT_MSG;
    // ログアウト画面
    if(is_file(__DIR__."/message/index.html")) require_once __DIR__."/message/index.html";
  }
  /********** END ログアウト処理 ********************/



  /**************************************************
   *
   * セッション情報をクリアする
   *
   **************************************************/
  public function session_clear(){
    // 変数を解放
    if(isset($_SESSION[ $this->uuid ])) unset($_SESSION[ $this->uuid ]);
    // クッキーを解放
    if(!isset($_COOKIE[ $this->uuid ])) unset($_COOKIE[ $this->uuid ]);
  }
  /********** END セッション情報をクリアする ********************/



  /**************************************************
   *
   * エラーメッセージを出力する
   *
   **************************************************/
  public function die_msg( $msg="" ){
    // Ajaxの場合JSONで出力
    if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'){
      header("Content-Type: application/json; charset=utf-8");
      echo json_encode(['status'=>'false', 'msg'=>$msg ]);
      exit;
    };// END if Ajaxの場合JSONで出力
    // dieで出力
    die( $msg );
  }
  /********** END エラーメッセージを出力する ********************/



  /**************************************************
   *
   * ログイン処理
   *
   *	使い方
   *		exec_login($db, $account, $password);
   *
   *	パラメータ
   *		$db
   *		（クラス）new DB()
   *		$account
   *		（文字列）アカウント
   *		$password
   *		（文字列）パスワード
   *
   *	戻り値
   *		ログインに成功
   *		（配列）アカウント情報
   *			'gid'
   *			（数値）グループID
   *			'gname'
   *			（文字列）グループ名
   *			'account'
   *			（文字列）アカウント
   *			'name'
   *			（文字列）名前
   *			'authority'
   *			（文字列）権限
   *		ログインに失敗
   *		（真偽値）false
   *
   **************************************************/
  public function exec_login($db, $account, $password){
    // アカウント情報を参照
    $master_account = $this->select__master_account($db
                                                   ,$account
                                                   ,$password
                      );
    // ログインに失敗
    if(!$master_account) return false;
    // ログインを記録
    $this->insert__login_history($db
                                ,$master_account
    );
    // セッションから同じアカウントを削除する
    $this->unset__session_account($account);
    // セッションに保存
    $_SESSION[ $this->uuid ] = array_merge($master_account, ['expiration'=>time()] );

    // アカウント情報を返す
    return array_merge($master_account, ['uuid'=>$this->uuid] );
  }
  /********** END ログイン処理 ********************/



  /************************************************************
   *
   * アカウント情報を参照
   *
   *	使い方
   *		select__master_account($db, $account, $password);
   *
   *	パラメータ
   *		$db
   *		（クラス）new DB()
   *		$account
   *		（文字列）アカウント
   *		$password
   *		（文字列）パスワード
   *
   *	戻り値
   *		（配列）アカウント情報
   *			'gid'
   *			（数値）グループID
   *			'gname'
   *			（文字列）グループ名
   *			'account'
   *			（文字列）アカウント
   *			'name'
   *			（文字列）名前
   *			'authority_name'
   *			（文字列）権限名
   *			'authority_priority'
   *			（文字列）権限の優先順位
   *
   ************************************************************/
  public function select__master_account($db, $account, $password){
    $query  = "SELECT `MAC`.`gid`";
    $query .= "      ,`MAC`.`account`";
    $query .= "      ,`MAC`.`name`";
    $query .= "      ,`MAC`.`authority` AS `authority_name`";
    $query .= "      ,`MAU`.`priority` AS `authority_priority`";
    $query .= "      ,`MG`.`name` AS `gname`";
    $query .= "  FROM `".DB_PREFIX."master_account` AS `MAC`";
    $query .= " INNER JOIN `".DB_PREFIX."master_authority` AS `MAU`";
    $query .= "         ON `MAU`.`name` = `MAC`.`authority`";
    $query .= " INNER JOIN `".DB_PREFIX."master_group` AS `MG`";
    $query .= "         ON `MG`.`id` = `MAC`.`gid`";
    $query .= "        AND `MG`.`is_enabled` =:is_enabled";
    $query .= " WHERE `MAC`.`account` =:account";
    $query .= "   AND `MAC`.`password` =:password";
    $query .= "   AND `MAC`.`is_enabled` =:is_enabled";
    $query .= " LIMIT 0, 1";
    $query .= ";";
    $bind = array(
      'account' => $account
     ,'password' => sha1($password)
     ,'is_enabled' => 1
    );
    $stmt = $db->Query($query, $bind, array('line' => __LINE__));
    return $stmt->fetch(PDO::FETCH_ASSOC);
  }
  /********** END アカウント情報を参照 ********************/



  /************************************************************
   *
   * ログインを記録
   *
   *	使い方
   *		insert__login_history($db, $master_account);
   *
   *	パラメータ
   *		$db
   *		（クラス）new DB()
   *		$master_account
   *		（配列）アカウント情報
   *			'account'
   *			（文字列）アカウント
   *
   *	戻り値
   *		（なし）
   *
   ************************************************************/
  public function insert__login_history($db, $master_account){
    $query  = "INSERT";
    $query .= "  INTO `".DB_PREFIX."login_history`";
    $query .= "   SET `account` =:account";
    $query .= "      ,`user_agent` =:user_agent";
    $query .= ";";
    $bind = array(
      'account' => $master_account['account']
     ,'user_agent' => $_SERVER['HTTP_USER_AGENT']
    );
    $stmt = $db->Query($query, $bind, array('line' => __LINE__));
  }
  /********** END ログインを記録 ********************/



  /************************************************************
   *
   * セッションから同じアカウントを削除する
   *
   *	使い方
   *		unset__session_account($account);
   *
   *	パラメータ
   *		$account
   *		（文字列）アカウント
   *
   *	戻り値
   *		（なし）
   *
   ************************************************************/
  public function unset__session_account($account){
    foreach($_SESSION as $uuid => $hash){
      // 未定義は処理しない
      if(!isset($hash['account'])) continue;
      // 違うアカウントは削除しない
      if($hash['account'] != $account) continue;
      // 削除する
      unset($_SESSION[ $uuid ]);
    };
  }
  /********** END セッションから同じアカウントを削除する ********************/



//  /**************************************************
//   *
//   * テンプレート
//   *
//   **************************************************/
//  public function XXXXXXXXXXXXX(){
//  }
//  /********** END テンプレート ********************/

};
?>