<?php
require_once "../commons/init.php";
/*************************************************************
 *
 * Copyright (c) 2022 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2022 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	: 2022.08.19
 *
 *************************************************************/
// デバッグ用なので、この行は不要です
if(is_file("../debug.php")) require_once "../debug.php";



// 戻り値
$result = array('status'=>'true');

// データベースに接続
$db = new DB(DB_HOST, DB_NAME, DB_USER, DB_PASS);
$db->Connect(1);
// ログイン処理
exec_login($db
          ,isset($_REQUEST[LOGIN_ACCOUNT]) ? $_REQUEST[LOGIN_ACCOUNT] : ""
          ,isset($_REQUEST[LOGIN_PASSWORD]) ? $_REQUEST[LOGIN_PASSWORD] : ""
);
// データベースから切断
$db->Disconnect( $result['status'] == "true" ? 1 : 0 );


header("Content-Type: application/json; charset=utf-8");
echo json_encode($result);
exit;



/************************************************************
 *
 * ログイン処理
 *
 *	使い方
 *		exec_login($db, $account, $password);
 *
 *	パラメータ
 *		$db
 *		（クラス）new DB()
 *		$account
 *		（文字列）アカウント
 *		$password
 *		（文字列）パスワード
 *
 *	戻り値
 *		（なし）
 *
 ************************************************************/
function exec_login($db, $account, $password){
  $Auth = new Auth();
  $result = $Auth->exec_login($db
                             ,$account
                             ,$password
            );
  // ログインに成功
  if($result) $GLOBALS['result']['account'] = $result;
  // ログインに失敗
  else{
    $GLOBALS['result'] = array(
      'status' => 'false'
     ,'msg' => LOG_IN_FAILED
    );
  };// END else
};
/********** END ログイン処理 ********************/



/************************************************************
 *
 * テンプレート関数
 *
 *	使い方
 *		func_template($args1, $args2);
 *
 *	パラメータ
 *		$args1
 *		（型）説明文
 *		$args2
 *		（型）説明文
 *
 *	戻り値
 *		（型）説明文
 *
 ************************************************************/
#function func_template($args1, $args2){
#};
/********** END テンプレート関数 ********************/



/************************************************************
 *
 * パラメータの数が変動する場合
 *
 *	使い方
 *		func_parameta(...$args);
 *
 *	パラメーター
 *		$args
 *		（配列）説明文
 *
 *	戻り値
 *		（型）説明文
 *
 ************************************************************/
#function func_parameta($args){
#};
/********** END パラメータの数が変動する場合 ********************/
?>