;
/*************************************************************
 *
 * Copyright (c) 2022 ysrock Co., Ltd.	<info@ysrock.co.jp>
 * Copyright (c) 2022 Yasuo Sugano	<sugano@ysrock.co.jp>
 *
 * Version	: 1.0.0
 * Update	: 2022.09.15
 *
 ************************************************************/
'use strict';
(function($){
  $(document).ready(function(){
    // タブ：ボタン型：クリックイベント
    $('div.theme_tab.button > ul > li').click( theme_tab_button.evtClick() );
    // タブ：ボタン型：初期化
    $('div.theme_tab.button').each( theme_tab_button.initial() );

    // タブ：線型：クリックイベント
    $('div.theme_tab.border > ul > li').click( theme_tab_border.evtClick() );

    // ボタン：タッチイベント※activeの為に
    $('button.theme_button').on('touchstart', function(){ });

    // メニュー：親メニュークリック
    $('#theme_nav > ul > li > a').click( theme_nav.parentMenuClick() );

    // 基本フレーム：リスト：クリックイベント
    $('#theme_frame_list > div.body > dl > dd > a').click( theme_frame_list.anchorClick() );
  });


  /**********************************************************************
   *
   *　画面回転・リサイズ時
   *
   **********************************************************************/
  $(window).on('orientationchange resize', function(){
    // タブ：ボタン型：クリックイベントを発火
    $('div.theme_tab').each(function(){ $('ul > li.this', this).trigger('click'); });
    // メニュー：閉じる
    $('body > div.theme_nav_child').remove();
  });



  /**********************************************************************
   *
   *　タブ：ボタン型
   *
   **********************************************************************/
  let theme_tab_button = (function(){
    return{
      /************************************************************
       *
       * 初期化
       *
       ************************************************************/
      'initial' : function(){
        return(function(idx){
          // 背景エレメント：定義
          if( theme_tab_button['elem'] === undefined ) theme_tab_button['elem'] = [];
          // 背景エレメント：作成
          theme_tab_button['elem'][idx] = $('<div>').addClass('white_box');
          // 背景エレメントを追加
          $(this).append(theme_tab_button.elem[idx]);
          // クリックイベントを発火
          $('ul > li.this', this).trigger('click');
        });
      },
      /********** END 初期化 ********************/



      /************************************************************
       *
       * クリックイベント
       *
       ************************************************************/
      'evtClick' : function(){
        return(function(){
          // 他のクラスを削除
          $(this).siblings('li').removeClass('this');
          // 自身にクラスを追加
          $(this).addClass('this');
          // インデックスを取得
          let idx = $('div.theme_tab.button').index( $(this).closest('div.theme_tab.button') );
          // 白箱のサイズを変更
          theme_tab_button['elem'][idx].css({
            'width' : $(this).outerWidth()
           ,'height' : $(this).outerHeight()
           ,'left' : $(this).position().left
          });// END css 白箱のサイズを変更
        });
      },
      /********** END クリックイベント ********************/

    }
  })();
  /********** END タブ：ボタン型 ********************/



  /**********************************************************************
   *
   *　タブ：線型
   *
   **********************************************************************/
  let theme_tab_border = (function(){
    return{
      /************************************************************
       *
       * クリックイベント
       *
       ************************************************************/
      'evtClick' : function(){
        return(function(){
          // 他のクラスを削除
          $(this).siblings('li').removeClass('this');
          // 自身にクラスを追加
          $(this).addClass('this');
        });
      },
      /********** END クリックイベント ********************/

    }
  })();
  /********** END タブ：線型 ********************/



  /**********************************************************************
   *
   *　メニュー
   *
   **********************************************************************/
  let theme_nav = (function(){
    return{
      /************************************************************
       *
       * 親メニュークリック
       *
       ************************************************************/
      'parentMenuClick' : function(){
        return(function(e){
          // 子メニューがない場合は処理しない
          if(!$(this).prevAll('ul')[0]) return;
          // 子メニューフレームのHTMLを作成
          let html = theme_nav.html_child_frame();
          // エレメント化
          let elem = $(html);
          // 背景クリックで閉じる
          $('div.background', elem).click( theme_nav.close_child_frame() );
          // 閉じるボタンで閉じる
          $('div.wrap > div.header > div.right > div.close', elem).click( theme_nav.close_child_frame() );
          // 見出し
          $('div.wrap > div.header > div.center', elem).text( $(this).text() );
          // 戻るボタン
          $('div.wrap > div.header > div.left > div.back', elem).click( theme_nav.prev_menu() );
          // 子・孫メニューリストを作成
          $('div.wrap > div.window_x > div.window_y > div.columns', elem).append(theme_nav.insert_menu_list( $(this).parent().children('ul').prop('outerHTML') ));
          // タッチイベント※activeの為に
          $('div.wrap > div.window_x > div.window_y > div.columns > ul > li > a', elem).on('touchstart', function(){ });
          // bodyに追加
          $('body').append( elem );
          // トランジション
          setTimeout(function(){ elem.removeClass('prepare'); }, 10);
        });
      },
      /*
       * 子メニューフレームのHTMLを作成
       */
      'html_child_frame' : function(){
        let html = "";
        html += "<div class=\"theme_nav_child prepare\">";
        html += " <div class=\"wrap\">";
        html += "  <div class=\"header\">";
        html += "   <div class=\"left\">";
        html += "    <div class=\"back hidden\"><span class=\"icon-left_02\"></span>戻る</div>";
        html += "   </div><!-- END div.left -->";
        html += "   <div class=\"center\"></div>";
        html += "   <div class=\"right\">";
        html += "    <div class=\"close\"><span class=\"icon-batsu_01\"></span></div>";
        html += "   </div><!-- END div.right -->";
        html += "  </div><!-- END div.header -->";
        html += "  <div class=\"window_x\">";
        html += "   <div class=\"window_y\">";
        html += "    <div class=\"columns\"></div>";
        html += "   </div><!-- END div.window_y -->";
        html += "  </div><!-- END div.window_x -->";
        html += "  <div class=\"footer\"></div>";
        html += " </div><!-- END div.wrap -->";
        html += " <div class=\"background\"></div>";
        html += "</div><!-- END div.menu -->";
        return html;
      },
      /*
       * 子メニューフレームを閉じる
       */
      'close_child_frame' : function(){
        return(function(){
          $(this).closest('div.theme_nav_child').remove();
        });
      },
      /*
       * 子・孫メニューリストを作成
       */
      'insert_menu_list' : function( html ){
        // エレメント化
        let elem = $(html);
        // さらに子メニューを表示
        $('li > ul + a', elem).click(function(){
          // 追加するメニューを取得
          let elem_ins = theme_nav.insert_menu_list( $(this).parent().children('ul').prop('outerHTML') );
          // 横に追加
          $(this).closest('div.columns').append( elem_ins );
          // 横スクロール
          $(this).closest('div.window_y').animate({
            scrollLeft:$(this).closest('div.columns').width()
           ,height:elem_ins.children('li').length * $(this).outerHeight()
          }, 300);// END 横スクロール
          // 戻るボタンを表示
          $(this).closest('div.wrap').children('div.header').children('div.left').children('div.back').removeClass('hidden');
        });
        // 戻り値
        return elem;
      },
      /*
       * 戻るボタン
       */
      'prev_menu' : function(){
        return(function(){
          // win_y：エレメント
          let elem_win_y = $(this).closest('div.wrap').children('div.window_x').children('div.window_y');
          // 表示させるメニュー：インデックス番号
          let idx_ul = $('div.columns > ul', elem_win_y).length - 2;
          // 表示させるメニュー：エレメント
          let elem_ul = $('div.columns > ul:eq(' + idx_ul + ')', elem_win_y);
          // 表示させるメニュー：子メニューのひとつ
          let elem_li = $(elem_ul).children('li');
          // 横スクロール
          $(elem_win_y).animate({
            scrollLeft:idx_ul * $(elem_win_y).width()
           ,height:elem_li.length * elem_li.outerHeight()
          }, 300, function(){
            // 最後のメニューを削除
            $('div.columns > ul:last-of-type', this).remove();
          });// END 横スクロール
          // 戻るボタンを非表示に
          if(idx_ul < 1) $(this).addClass('hidden');
        });
      },
      /********** END 親メニュークリック ********************/

    }
  })();
  /********** END メニュー ********************/



  /**********************************************************************
   *
   *　基本フレーム：リスト
   *
   **********************************************************************/
  let theme_frame_list = (function(){
    return{
      /************************************************************
       *
       * クリックイベント
       *
       ************************************************************/
      'anchorClick' : function(){
        return(function(e){
          // 外部リンクがある場合は処理しない
          if($(this).attr('target')) return;
          // イベントをキャンセル
          e.preventDefault();
          // リスト：他のリンクからアクティブクラスを除去する
          $('#theme_frame_list > div.body > dl > dd > a').removeClass('active');
          // リスト：アクティブクラスを加える
          $(this).addClass('active');
          // スピナー：表示
          let elem_spinner = $.fn.ysIosSpinner();

          // 非同期タスク：コールバック
          let cb = function(data, textStatus, jqXHR){
            // スピナーを閉じる
            elem_spinner.remove();
          };
          // 非同期タスク：HTMLを取得
          theme_frame_page.asyncGetHtml($(this).attr('href'), cb);
        });
      },
      /********** END クリックイベント ********************/

    }
  })();
  /********** END 基本フレーム：リスト ********************/



  /**********************************************************************
   *
   *　詳細ページ
   *
   **********************************************************************/
  let theme_frame_page = (function(){
    return{
      /************************************************************
       *
       * HTMLの作成
       *
       ************************************************************/
      'makeBaseHtml' : function(){
console.log(['使ってない？', '22.09.15']);
return "";
        let html = "";
        html += "<div class=\"theme_frame_page prepare\">";
        html += " <div class=\"header\">";
        html += "   <div class=\"left\"></div>";
        html += "   <div class=\"center\"></div>";
        html += "   <div class=\"right\"></div>";
        html += " </div><!-- END div.header -->";
        html += " <div class=\"body\"></div>";
        html += "</div>";
        return html;
      },
      /********** END HTMLの作成 ********************/



      /************************************************************
       *
       * 非同期タスク：HTMLを取得
       *
       ************************************************************/
      'asyncGetHtml' : function( url, cb ){
        // Ajaxの準備
        let objAjax = $.fn.ysAjax();
        // 送信先
        objAjax.settings.url = theme_frame_page.addUuid( url );
        // メソッド
        objAjax.settings.method = 'GET';
        // 受信データ
        objAjax.settings.dataType = 'html';
        // Ajax通信
        $.ajax(objAjax.settings).fail(objAjax.fail(objAjax)).done(function(data, textStatus, jqXHR){
          // 成功以外は処理しない
          if(textStatus != 'success') return;
          // 戻り値をJSONに変換
          let result = $.fn.ysToJSON(data);
          // JSON以外の場合
          if(result === false){
            // エレメント化
            let elem = $(data);
            // 左からのスワイプで閉じる
            $(elem).ysSwipeOut();
            // 末尾に追加
            $('body').append(elem);
            // トランジション
            let func = function(elem){ elem.removeClass('prepare'); };
            setTimeout(func, 100, elem);
            // コールバック
            if(typeof cb == "function") cb(data, textStatus, jqXHR);
          }// END if
          // Locationがある時
          else if('location' in result) location.href = result['location'];
          // 想定外の値
          else console.log([ data, textStatus, jqXHR ]);
        });
      },
      /*
       * URLにUUIDがあればhrefに付加する
       */
      'addUuid' : function( href ){
        // URLからUUIDを取得
        let uuid = location.search.match(/[\?&]?uuid=([^\x26]+)\x26?/) ? RegExp.$1 : "";
        // 処理しない：UUIDが無い
        if(!uuid) return href;
        // 処理しない：ハッシュタグのみ
        if(href.match(/^#/)) return href;
        // 処理しない：既にUUIDがある
        if(href.match(/uuid=/)) return href;
        // 処理しない：外部リンク
        if(href.match(/\/\//)) return href;
        // UUIDを付加
        return href + (href.match(/\?/) ? "&" : "?") + 'uuid=' + uuid;
      },
      /********** END 非同期タスク：HTMLを取得 ********************/

    }
  })();
  /********** END 詳細ページ ********************/



//  /**********************************************************************
//   *
//   *　即時関数
//   *
//   **********************************************************************/
//  let capsule = (function(){
//    return{
//      /************************************************************
//       *
//       * メソッド
//       *
//       ************************************************************/
//      'method' : function(){
//      },
//      /********** END メソッド ********************/
//
//    }
//  })();
//  /********** END 即時関数 ********************/

})(jQuery);