<?php
// *************************************************************
// *
// * Copyright (c) 2024 ysrock Co., Ltd.	<info@ysrock.co.jp>
// * Copyright (c) 2024 Yasuo Sugano		<sugano@ysrock.co.jp>
// *
// * Version	: 1.0.8
// * Update	: 2024.07.01
// *
// *************************************************************
// *
// * Interface
// *
// * $hoge = new DB( (string)$host, (string)$db, (string)$user, (string)$pass);
// *		$error = 'die' | 'return';
// *
// * $hoge->Connect( $begin );
// *
// * $hoge->Query( (string)$query, (array)$bind, (array)$option);
// *
// * $hoge->Disconnect( $commit );
// *
// * $hoge->LastInsertId();
// *
// * $hoge->Transaction();
// *
// * $hoge->Rollback();
// *
// * $hoge->Commit();
// *
// *************************************************************
class DB{
  public $dbh,$begin,$host,$db,$user,$pass;

  public function __construct($host="", $db="", $user="", $pass=""){
    $this->host	= $host;
    $this->db	= $db;
    $this->user	= $user;
    $this->pass	= $pass;
  }

  public function Connect($begin=null){
    $this->begin=$begin;
    try{
      $this->dbh=new PDO('mysql:host='.$this->host.';dbname='.$this->db.';charset=utf8',$this->user,$this->pass, array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET CHARACTER SET `utf8`'));
      $this->dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
      $this->dbh->setAttribute(PDO::ATTR_AUTOCOMMIT, false);
      $this->dbh->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);
      $this->dbh->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY , true);
      if($begin) $this->dbh->beginTransaction();
    }catch (Exception $e){ exit('DB Error: connect failed: '.$e->getMessage()); die(); }
  }

  public function Query($query,$bind,$option){
    if(!$query) die("arg[0] is null");
    if(!is_array($bind)) die("arg[1] is not array");
    if(!is_array($option)) die("arg[2] is not array");
    $line="";
    if(isset($option['line'])) $line=$option['line'];
    try{
      $stmt=$this->dbh->prepare($query);
      foreach($bind as $key=>$value){
        if(is_int($value)) $param=PDO::PARAM_INT;
        elseif(is_bool($value)) $param=PDO::PARAM_BOOL;
        elseif(is_null($value)) $param=PDO::PARAM_NULL;
        elseif(is_string($value)) $param=PDO::PARAM_STR;
        else continue;
        $stmt->bindValue(":{$key}",$value,$param);
      }
      $stmt->execute();
      return $stmt;
    }catch (Exception $e){
// php5.3.3      if($this->begin && $this->dbh->inTransaction()) $this->dbh->rollBack();
      if($this->begin) $this->dbh->rollBack();
//      exit('DB Error: connect failed: '.$e->getMessage()."\n\n".$line."\n".$query);
      exit('DB Error: execute error: '.$e->getMessage()."\n\n".$line."\n\n\t{$query}\n\n\t".implode("\n\t",$bind)."\n");
      die();
    }
  }

  public function Disconnect($commit=null){
// php5.3.3    if($this->begin && $this->dbh->inTransaction()){
    if($this->begin){
      if($commit) $this->dbh->commit();
      else $this->dbh->rollBack();
    }
    $this->dbh=null;
  }

  public function LastInsertId(){
    return $this->dbh->lastInsertId();
  }

  public function Transaction(){
    if($this->begin) return;
    $this->dbh->beginTransaction();
  }

  public function Rollback(){
    $this->dbh->rollBack();
  }

  public function Commit(){
    $this->dbh->commit();
  }

}
?>