<?php
// *************************************************************
// *
// * Copyright (c) 2022 ysrock Co., Ltd.	<info@ysrock.co.jp>
// * Copyright (c) 2022 Yasuo Sugano		<sugano@ysrock.co.jp>
// *
// * Version	: 1.0.6
// * Update	: 2022.08.17
// *
// *	Code取得時に値がNULLの時の処理を変更
// *
// *************************************************************
// *
// * Version	: 1.0.5
// * Update	: 2022.07.12
// *
// *	Code取得時に値がNULLの時の処理を変更
// *
// *************************************************************
// *
// * Version	: 1.0.4
// * Update	: 2022.04.11
// *
// *	入力文字列がNULLの時の処理を変更
// *		前：die
// *		後：return ""
// *
// *************************************************************
// *
// * Version	: 1.0.3
// * Update	: 2022.04.07
// *
// *	$string = "0" の時、""を返してしまう
// *
// *************************************************************
// *
// * Version	: 1.0.2
// * Update	: 2021.12.03
// *
// *	パラメータが空の時はdieではなく空を返す
// *	dieの時、ファイル名も返す
// *
// *************************************************************
// *
// * Version	: 1.0.0
// * Update	: 2015.12.22
// *
// *************************************************************
// *
// * USING
// *
// * mb_convert_encoding();
// *
// *************************************************************
// *
// * INTERFACE
// *
// * $hoge=new YsChar();
// *
// * 文字コードを調る
// * string $hoge->Code( string $string )
// *
// * 文字コードを変更する
// * string $hoge->Encode( string $string , string $after [, string $before ] )
// *
// *************************************************************

class YsChar{
  public $ascii='(?:[\x20-\x7E])';
  public $euc  ='(?:[\x20-\x7E])|(?:\x8E[\xA1-\xDF])|(?:[\xA1-\xFE][\xA1-\xFE])|(?:\x8F[\xA1-\xFE][\xA1-\xFE])';
  public $jis  ='(?:[\x20-\x7E])|(?:\x1B\x28\x42[\x20-\x7E]*)|(?:\x1B\x28\x4A[\x20-\x7E]*)|(?:\x1B\x28\x49[\x21-\x5F]*)|(?:\x1B\x24\x40[\x21-\x7E]*)|(?:\x1B\x24\x42[\x21-\x7E]*)|(?:\x1B\x24\x44[\x21-\x7E]*)';
  public $sjis ='(?:[\x20-\x7E])|(?:[\xA1-\xDF])|(?:[\x81-\x9F\xE0-\xEF][\x40-\x7E\x80-\xFC])';
  public $utf8 ='(?:[\x20-\x7E])|(?:[\xC0-\xDF][\x80-\xBF])|(?:[\xE0-\xEF][\x80-\xBF][\x80-\xBF])|(?:[\xF0-\xF7][\x80-\xBF][\x80-\xBF][\x80-\xBF])|(?:[\xF8-\xFB][\x80-\xBF][\x80-\xBF][\x80-\xBF][\x80-\xBF])|(?:[\xFC-\xFD][\x80-\xBF][\x80-\xBF][\x80-\xBF][\x80-\xBF][\x80-\xBF])';

  public function Code($string){
    if(!$string) return "";
    $res = @mb_detect_encoding($string);
    if(is_null($res)) return "";
    return $res;
  }

  public function Encode($string,$after,$before=""){
    if(!$string || !$after) return $string;
    /*--- 文字コードの整理 ---*/
    if(preg_match("/^ascii$/i",$after)) return($string);
    elseif(preg_match("/^utf-?8$/i",$after)) $after='UTF-8';
    elseif(preg_match("/^euc/i",$after)) $after='EUC-JP';
    elseif(preg_match("/^s.*jis$/i",$after)) $after='SJIS';
    elseif(preg_match("/^jis$/i",$after) || preg_match("/^iso-2022-jp$/i",$after)) $after='JIS';
    else die(var_dump([__FILE__, __LINE__, "args[1] is invalid.\n".$string ]));
    /*--- 文字コードの取得 ---*/
    if(!$before) $before=$this->Code($string);
    /*--- 文字コードの整理 ---*/
    if(preg_match("/^ascii$/i",$before)) return($string);
    elseif(preg_match("/^utf-?8$/i",$before)) $before='UTF-8';
    elseif(preg_match("/^euc/i",$before)) $before='EUC-JP';
    elseif(preg_match("/^s.*jis$/i",$before)) $before='SJIS';
    elseif(preg_match("/^jis$/i",$before) || preg_match("/^iso-2022-jp$/i",$before)) $before='JIS';
    else return "";
    /*--- エンコード ---*/
    return mb_convert_encoding($string,$after,$before);
  }
}
?>